## Link

### Display Text

Providing accessible *Display Text* is straightforward if you keep the
following guidelines in mind:

1. The *Display Text* for a link should describe the target of the link.

1. Do not use ambiguous text, such as “Click Here” or “More”.

1. Do not begin the *Display Text* with redundant words or phrases such as
   “Link” or “Link to”.

1. Be consistent: Links to the same URL or e-mail address should have the same
   *Display Text*.

1. In most cases, it is best not to use the link URL or e-mail address as the
   *Display Text*.

### About links

* Screen reader users often use the “List of Links” feature to identify and
  navigate to links on a page. When links are presented as a list,  using
  descriptive *Display Text* becomes even more important since understanding
  the target of each link no longer benefits from its original context within
  the document.

* Screen reader users often use the “Search” feature to find links on a page
  based on keywords they would expect to find in the *Display Text* of the
  links. Thus the more descriptive the link *Display Text*, the more effective
  the search feature will be in finding relevant links.

* Usable and accessible *Display Text* should be descriptive, unique and start
  with keywords (NNG).

* The *Display Text* for links is like a sign post. It should tell you what
  you’ll find when you follow it (NOMENSA).

### Why links are important

* Descriptive link text makes it easier for everyone to find and follow links
  on a page that are of interest to them.

* Descriptive link text is especially important for people using screen
  readers, who typically only hear the display text spoken to them through
  speech synthesis and do not "see" the link in the context of other content
  on the page.

* When URLs, e-mail addresses or other ambiguous text are used as the display
  text for a link, it is impossible in many cases, and much more difficult in
  the remaining cases, for screen reader users to find and follow links of
  interest to them.

### More information

* <a href="https://www.nngroup.com/articles/writing-links/"
target="_resource">NNG: Writing Hyperlinks: Salient, Descriptive, Start with
Keyword</a>

* <a href="https://www.nomensa.com/blog/2011/writing-good-link-text"
target="_resource">Nomensa: How to write good link text</a>

* <a href="https://accessibility.umn.edu/core-skills/hyperlinks"
target="_resource">Accessible U: Hyperlinks (Good and Bad Examples)</a>
